/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.loot.modifiers;

import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CakeBlock;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.state.Property;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import vectorwing.farmersdelight.blocks.PieBlock;

public class PastrySlicingModifier
extends LootModifier {
    public static final int MAX_CAKE_BITES = 7;
    public static final int MAX_PIE_BITES = 4;
    private final Item pastrySlice;

    protected PastrySlicingModifier(ILootCondition[] conditionsIn, Item pastrySliceIn) {
        super(conditionsIn);
        this.pastrySlice = pastrySliceIn;
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        BlockState state = (BlockState)context.func_216031_c(LootParameters.field_216287_g);
        if (state != null) {
            Block targetBlock = state.func_177230_c();
            if (targetBlock instanceof CakeBlock) {
                int bites = (Integer)state.func_177229_b((Property)CakeBlock.field_176589_a);
                generatedLoot.add(new ItemStack((IItemProvider)this.pastrySlice, 7 - bites));
            } else if (targetBlock instanceof PieBlock) {
                int bites = (Integer)state.func_177229_b((Property)PieBlock.BITES);
                generatedLoot.add(new ItemStack((IItemProvider)this.pastrySlice, 4 - bites));
            }
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<PastrySlicingModifier> {
        public PastrySlicingModifier read(ResourceLocation location, JsonObject object, ILootCondition[] conditions) {
            Item pastrySlice = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)"slice")));
            return new PastrySlicingModifier(conditions, pastrySlice);
        }

        public JsonObject write(PastrySlicingModifier instance) {
            return new JsonObject();
        }
    }
}

